/*
 * Decompiled with CFR 0.152.
 */
package itx.core.web;

import com.fasterxml.jackson.core.exc.StreamWriteException;
import com.fasterxml.jackson.databind.DatabindException;
import itx.core.web.WebRequest;
import itx.erp.ErpObjectContainer;
import itx.erp.base.model.User;
import itx.erp.base.service.UserService;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.HashMap;
import jtbcore.exception.AuthorizationException;
import jtbcore.exception.ContainerException;

public abstract class BaseController {
    public ErpObjectContainer objectContainer;

    public abstract void handleRequest(WebRequest var1) throws Exception;

    protected void checkAdmin(WebRequest req) throws AuthorizationException, ContainerException, SQLException {
        Integer userId = req.getUserId();
        if (userId == null) {
            throw new AuthorizationException("User not logged in");
        }
        UserService uservice = ErpObjectContainer.getInstance().getUserService();
        User user = uservice.readUser(userId);
        if (user == null) {
            throw new AuthorizationException("User not found");
        }
        if (!user.isAdmin()) {
            throw new AuthorizationException("No administrator rights");
        }
    }

    public void executeAction(WebRequest req) throws NoSuchMethodException, SecurityException, IllegalAccessException, InvocationTargetException, StreamWriteException, DatabindException, IOException {
        String a = req.getParameter("a");
        if (a == null || a.trim().length() == 0) {
            a = "index";
        }
        try {
            Method m = this.getClass().getMethod(a + "Action", WebRequest.class);
            m.invoke((Object)this, req);
        }
        catch (NoSuchMethodException ex) {
            System.err.println("Error: BaseController.executeAction, Action not found: \"" + a + "\"");
            HashMap<String, Object> r = new HashMap<String, Object>();
            r.put("error", true);
            r.put("message", "Action not found");
            req.renderJson(r);
        }
    }
}

